unit Main;

//       ,
//        
//   .

//=============================================
interface
uses
  Windows, Messages, SysUtils, Variants, Classes,
  Graphics, Controls, Forms, Dialogs, StdCtrls, ExtCtrls;
//=============================================
type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Memo1: TMemo;
    Label2: TLabel;
    ComboBox1: TComboBox;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
var
  Form1: TForm1;
//=============================================
implementation
{$R *.dfm}


//=============================================
//   TOBJ1
type TQItem = class (TObject)
  private
    fPNext : pointer;
    fSData : string;
    //   
    procedure SetPNextToOBJ(RqPNext : pointer);
    procedure SetDataToOBJ(RqSData : string);
    function  GetPNextFromOBJ() : pointer;
    function  GetDataFromOBJ() : string;
  public
    //  
    property PNext : pointer read GetPNextFromOBJ write SetPNextToOBJ;
    property SData : string read GetDataFromOBJ write SetDataToOBJ;
    //        
    procedure PropShow(RqReport : TMemo); virtual;
end;


//=============================================
//    TOBJ1
//         
procedure TQItem.SetPNextToOBJ(RqPNext : pointer);
begin
  if Assigned(RqPNext)
  then begin
     try
        //  RqPNext    
        //  TObject(RqPNext) is TQItem
        //   
        if TObject(RqPNext) is TQItem
        then fPNext := RqPNext
        else begin
           fPNext := nil;
           ShowMessage ( format('%p',[RqPNext])
                       + ' -     '
                       + TObject(RqPNext).ClassName
                       + #13
                       + '      ');
        end;
     except
        fPNext := nil;
        ShowMessage ( format('%p',[RqPNext])
                     + ' -     '
                     + #13
                     + '      ');
     end;
  end
  else fPNext := nil;
end;

//    
procedure TQItem.SetDataToOBJ(RqSData : string);
begin fSData := RqSData; end;

//      
function  TQItem.GetPNextFromOBJ() : pointer;
begin Result := fPNext; end;

//      
function  TQItem.GetDataFromOBJ() : string;
begin Result := fSData; end;

//        
procedure TQItem.PropShow(RqReport : TMemo);
var P1 : pointer;        //  
begin
  P1 := Self;
  RqReport.Lines.Add('  = ' + format('%p',[P1]));
  if Assigned(fPNext)
  then RqReport.Lines.Add(' fPNext = ' + format('%p',[fPNext]))
  else RqReport.Lines.Add(' fPNext = NIL');
  RqReport.Lines.Add(' fSData = ' + fSData);
end;

//=============================================
// 
procedure TForm1.Button1Click(Sender: TObject);
var Obj1, Obj2 : TQItem;   //    
begin
   case ComboBox1.ItemIndex of
   0 : begin  //      TQItem
       Obj1 := TQItem.Create;
       Obj1.PNext := nil;
       Obj1.SData := '  1';
       Memo1.Clear;
       Obj1.PropShow(Memo1);
       Obj1.Free;
   end;
   1 : begin  //       TQItem
       //    1
       Obj1 := TQItem.Create;
       Obj1.SData := '  1';
       //    2
       Obj2 := TQItem.Create;;
       Obj2.SData := '  2';
       //    1    2  
       Obj1.PNext := Obj2;
       // 
       Memo1.Clear;
       Obj1.PropShow(Memo1);
       Obj2.PropShow(Memo1);
       //  
       Obj1.Free;
       Obj2.Free;
   end;
   2 : begin  //      
       //    1
       Obj1 := TQItem.Create;
       Obj1.SData := '  1';
       //     1     
       Obj1.PNext := Label2;
       // 
       Memo1.Clear;
       Obj1.PropShow(Memo1);
       //  
       Obj1.Free;
   end;
   end; // of case

end;

end.
